function main()

[A,b,e] = unos;

while ( det(A)==0 | ~dijag_domin(A) )   
    if (det(A)==0 )                      % ako matrica nije regularna
        A = unos2;                       % poruka, i zahtev za novi unos    
    end
    if ( ~dijag_domin(A) )               % ako matrica nije dijagonalno dominantna
        A = unos3;                       % poruka, i zahtev za novi unos
    end
end

[B,c] = transf_u_norma_manja_od_jedan(A,b);
[resenje, broj_iter] = prosta_iter(B,c,c',e);
disp('PROSTA ITERACIJA:   ');
ispis(resenje,broj_iter);
[resenje, broj_iter] = Gaus_Zajdel(B,c,c',e);
disp('GAUS-ZAJDEL:   ');
ispis(resenje,broj_iter);

% graficki prikaz
ind = 1;
niz = zeros(3,ind);
for e=0.000001:0.000002:0.001
    [resenje, P_br_iter] = prosta_iter(B,c,c',e);
    [resenje, Z_br_iter] = Gaus_Zajdel(B,c,c',e);
    niz(1,ind) = e;
    niz(2,ind) = P_br_iter;
    niz(3,ind) = Z_br_iter;
    ind = ind+1;
end

plot(niz(1,:),niz(2,:),'--r',niz(1,:),niz(3,:),'-.b');
legend('Metod proste iteracije','Gaus-Zajdelov metod');
xlabel('tacnost (e)','FontSize',8)
ylabel('broj iteracija','FontSize',8)
title('Zavisnost broja iteracija od zadate tacnosti','FontSize',12)
clear all;


%---------------- unos -------------------

function [A,b,e] = unos()

A = input('Unestite matricu sistema.\nA = ');
b = input('Unesite kolonu slobodnih clanova.\nb = ');
e = input('Unesite tacnost sa kojom zelite rezultat.\ne = ');


%------------ dijag_domin ------------
function bool = dijag_domin(X)
% ispituje da li je matrica X dijagonalno dominantna

red = length( X(1,:) );
bool = 1;
for (i=1:red)            % ispituje po vrstama
    if ( bool==1 )       % ako sve prethodne vrste ne narusavaju uslov dijagonalne dominantnosti
        suma = 0;
        for (j=1:red)
            suma = suma + abs( X(i,j) );
        end
        suma = suma - abs( X(i,i) );
        if ( abs( X(i,i) ) <= suma );  % (*)
            bool = 0;
        end
    end
end
% tek ako u svim vrstama nije ispunjen uslov (*),
% matrica je dijagonalno dominantna


%----------- unos2 -----------
function X = unos2()

X = input('Matrica sistema koju ste uneli je singularna. Unesite regularnu matricu.\nA = ');


%-------- unos3 --------------
function A = unos3()

% ako matrica nije dijagonalno dominantna
A = input('Matrica koju ste uneli nije dijagonalno dominantna. Ponovite unos.\nA = ');


%-------- transf_u_norma_manja_od_jedan --------------
function [B,c] = transf_u_norma_manja_od_jedan(X,b)

%najpre pravimo prosirenu matricu sistema: [A|b]
red = length(b);
A = zeros(red,red+1);
A(:,1:red) = X;
A(:,red+1) = b;

for i=1:red
    A(i,:) = A(i,:)./(-A(i,i));
    A(i,i) = 0;
end

B = A(1:red,1:red); 
c = -A(1:red,red+1);  % - da bi ponistio gornji -, koji nije trebao za b


%------------ prosta_iter --------------
function [resenje,broj_iter] = prosta_iter(A,b,x0,e)
% odredjuje priblizno resenje sistema sa zadatom tacnoscu e

nor = norm(A,inf);
red = length(b);

tacnost = ones(1,red).*( ((1-nor)/nor)*e );
provera = tacnost+1;  % da bi se uslo u while
x = zeros(1,red);

x = x0*A' + b';
xn = x;
provera = abs( x-x0 );
broj_iter = 1;

while ( tacnost_zadovoljena(tacnost,provera) == 0 )
    xn = x;
    x = xn*A' + b';   %pisem x*A'+b=0, a ne A*x+b=0, da bih radio sa vrstama-vektorima, ne sa kolonama!
    provera = abs( x-xn );
    broj_iter = broj_iter+1;
end

resenje = xn;
broj_iter = broj_iter-1;


%----------------- Gaus_Zajdel -----------------
function [resenje, broj_iter] = Gaus_Zajdel(A,b,x0,e)
% Zajdelovom metodom odredjuje priblizno resenje sistema sa zadatom tacnoscu e

nor = norm(A,inf);
red = length(b);

tacnost = ones(1,red).*( ((1-nor)/nor)*e );
provera = tacnost+1;  % da bi se uslo u while
x = zeros(1,red);

broj_iter = 0;
stara = x0;
xn = x0;
resenje = xn;

while ( tacnost_zadovoljena(tacnost,provera) == 0 )   
    % izracunavanje
    resenje = xn;
    x(1) = xn*A(1,:)' + b(1);
    for i=2:red
        for j=1:i-1
            xn(j) = x(j);   % popravljanje koordinata tekuce iteracije na osnovu njenih vec izracunatih koordinata
        end
        x(i) = xn*A(i,:)' + b(i);
    end
    
    provera = abs( x-stara );
    broj_iter = broj_iter+1;
    stara = x;
    xn = x;
end


%--------- tacnost_zadovoljena -----------
function bool = tacnost_zadovoljena(t,p)
% pomocna f-ja za f-ju iter_alg;
% odredjuje kada je zadovoljena tacnost

len = length(t(1,:));
bul = 0;
for i=1:len
    if ( p(1,i) <= t(1,i) )
        bul = bul + 1;
    end
end
if ( bul ~= len )
    bool = 0;
else
    bool = 1; 
end


%--------- ispis -----------
function ispis(resenje,broj_iter)

disp('resenje:  ')
disp(resenje);
disp('broj iteracija:  ');
disp(broj_iter);


%---------------------------






    
